/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "CommandManager.h"

CommandManager::CommandManager(iAdminHandlerLayer *h) {

    l = log::instance();
    cp = new CommandPackager();
    ahl = h;
}

CommandManager::~CommandManager() {

    delete cp;
    l = NULL;
    ahl = NULL;
}

int CommandManager::open(int serial, char *disp, int dscin, int dscout) {

    commPackage *cpack;
    char *msg, *res;
    int nlen, epin, epout, id;
    bool ok;

    if (dscin != NULL_IN) {
        epin = ahl->requestEpIn(serial, dscin);
    }
    else {
        epin = 0;
    }
    if (dscout != NULL_OUT) {
        epout = ahl->requestEpOut(serial, dscout);
    }
    else {
        epout = 0;
    }
    if ((epin != HNDERROR) && (epout != HNDERROR)) {
        cpack = new commPackage();
        cpack->tc = OPEN;
        cpack->usbin = epin;
        cpack->usbout = epout;
        strcpy(cpack->name,disp);
    }
    else {
        return HNDERROR;
    };
    msg = cp->buildPackage(cpack, nlen);
    delete cpack;

    id = ahl->buildModuleID(serial, U4AHND);

    if (ahl->send(id, msg, nlen, DELAYSEND)) {
        delete [] msg;
        res = ahl->receive(id, ok, nlen, DELAYRECV);
        if (ok) {
            cpack = cp->unbuildPackage(res,nlen);
            if (cpack->newhnd != HNDERROR) {
                id = ahl->buildModuleID(serial,cpack->newhnd);
                ahl->registerModule(id, serial, cpack->newhnd, epin, epout);
            }
            else {
                l->printLog("A error ocurred when the device was opened.",true,true);
                id = HNDERROR;
            }
            delete res;
            delete cpack;
            return id;
        }
    }
    else {
        delete [] msg;
    }
    return HNDERROR;
}

bool CommandManager::close(int id) {

    commPackage *cpack;
    int nlen, serial, hnd, idbase;
    char *msg, *res;
    bool ok;

    if (ahl->existsModule(id)) {

        hnd = ahl->getHandlerID(id);
        serial = ahl->getSerialNumber(id);

        cpack = new commPackage();
        cpack->tc = CLOSE;
        cpack->hnd = hnd;
        msg = cp->buildPackage(cpack, nlen);
        delete cpack;

        idbase = ahl->buildModuleID(serial, U4AHND);

        if (ahl->send(idbase,msg,nlen,DELAYSEND)) {
            delete [] msg;
            res = ahl->receive(idbase, ok, nlen,DELAYRECV);
            if (ok) {
                cpack = cp->unbuildPackage(res,nlen);
                if (cpack->ack == 1) {
                    ok = true;
                    ahl->unregisterModule(id);
                }
                else {
                    ok = false;
                };
                delete cpack;
                delete [] res;
                return ok;
            };
        }
        else {
            delete [] msg;
        };
    };
    return false;
}

int* CommandManager::getBoards(int& cant) {

    return (ahl->getU4ABoards(cant));
}

char* CommandManager::getModules(int serial, int& cant) {

    commPackage *cpack;
    char *msg, *temp, *res = NULL;
    int nlen, id;
    bool ok;

    cant = 0;
    cpack = new commPackage();
    cpack->tc = MODULE_QTY;
    msg = cp->buildPackage(cpack, nlen);
    delete cpack;

    id = ahl->buildModuleID(serial, U4AHND);

    if (ahl->send(id, msg, nlen, DELAYSEND)) {
        delete [] msg;
        temp = ahl->receive(id, ok, nlen, DELAYRECV);
        if (ok) {
            cpack = cp->unbuildPackage(temp,nlen);
            delete [] temp;
            cant = cpack->cant;
            delete cpack;
            if (cant > 0) {
                res = new char [cant*MAX_LEN_NAME];
                for (int i=0; i<cant; i++) {
                    cpack = new commPackage();
                    cpack->tc = MODULE_NAME;
                    cpack->index = i;
                    msg = cp->buildPackage(cpack, nlen);
                    delete cpack;
                    if (ahl->send(id, msg, nlen, DELAYSEND)) {
                        delete [] msg;
                        temp = ahl->receive(id, ok, nlen,DELAYRECV);
                        if (ok) {
                            cpack = cp->unbuildPackage(temp, nlen);
                            delete [] temp;
                            for (int j=0; j < MAX_LEN_NAME; j++) {
                                res[(i*MAX_LEN_NAME)+j] = cpack->mod[j];
                            };
                            delete cpack;
                        }
                    }
                    else {
                        delete [] msg;
                    }
                }
            }
        }
    }
    else {
        delete [] msg;
    }
    return res;
}

void CommandManager::reset(int serial) {

    commPackage *cpack;
    char *msg;
    int nlen, id;
    bool ok;

    cpack = new commPackage();
    cpack->tc = INIT;
    msg = cp->buildPackage(cpack, nlen);
    delete cpack;

    id = ahl->buildModuleID(serial, U4AHND);

    if (ahl->send(id, msg, nlen, DELAYSEND)) {
        delete [] msg;
        msg = ahl->receive(id, ok, nlen, DELAYRECV);
        if (ok) {
            ahl->unregisterAllModules(serial);
        }
    }
    delete [] msg;
}

int CommandManager::getApiVersion() {

    return _API_VERSION;
}

int CommandManager::getFirmwareVersion(int serial) {

    // Esta faltando implementar el commando GETVERSION a nivel
    // del Admin Module para que devuelva su versin.
    serial = 2;
    return serial;
}
